--[[
Background todo:
1) Decide if the Tokyo Dome is being kept or not.
2) Re-implement hour-based stuff by modifying the theme color ever so slightly.
--]]
local hour = Hour();

-- this table makes assumptions, which is bad.
-- it also conflicts with the text.
local brightnessByHour = {
	0.4, -- midnight
	0.5,
	0.6,
	0.7,
	0.8,
	0.9,
	0.9125, -- more often than not, it's starting to brighten up.
	0.925,
	0.9375,
	0.95,
	0.9625,
	0.975,
	1.0, -- noon
	0.975,
	0.95,
	0.925,
	0.8,
	0.7,
	0.6,
	0.5,
	0.4, -- more often than not it's dark by this time.
	0.35,
	0.3,
	0.35,
};

-- old stuff from dubaiOne (random backgrounds)
--[[
local backgrounds = {
	Day = {"_amazing","_ocean","_skyline","_strip"},
	Dusk = {"_brilliant","_cloud","_dusk","_sun"},
	Night = {"_brightlight","_nightfront","_nightlights","_pool"}
};

local background = 0;
local index = math.random(1,4);

-- time checks
if (hour >= 0 and hour <= 6) or (hour >= 20) then
	-- nighttime.
	index = math.random(1,#backgrounds['Night']);
	background = "night/"..backgrounds['Night'][index];
-- lolbugfix (was >= 7)
elseif (hour >= 6 and hour <= 17) then
	-- daytime.
	index = math.random(1,#backgrounds['Day']);
	background = "day/"..backgrounds['Day'][index];
else
	-- dusk.
	index = math.random(1,#backgrounds['Dusk']);
	background = "dusk/"..backgrounds['Dusk'][index];
end;

--Trace("AJ DEBUG [_shared bg]: index = ".. index);
--]]

local themeColor = GetThemeColor();
local editorFadeTime = 0.5; -- was 0.2

local t = Def.ActorFrame{
	LoadActor( THEME:GetPathB("","_white") )..{
		--InitCommand=cmd( diffuse,Brightness(themeColor,brightnessByHour[hour+1]) );
		InitCommand=cmd( diffuse,themeColor );
		EditorShowMessageCommand=cmd(stoptweening;linear,editorFadeTime;diffusealpha,1);
		EditorHideMessageCommand=cmd(stoptweening;linear,editorFadeTime;diffusealpha,0.25);
	};

	LoadActor("_temp")..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;scaletocover,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;diffuseshift;effectcolor1,color("1,1,1,0.08");effectcolor2,color("1,1,1,0.12");effectperiod,5);
	};

	--[[
	LoadActor(background)..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;scaletocover,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;diffuseshift;effectcolor1,color("1,1,1,0.08");effectcolor2,color("1,1,1,0.12");effectperiod,5);
	};
	--]]
};

return t;